/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.SortLabels;

public class SortLabelsTest
extends AbstractFilterTest {
    public SortLabelsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.deleteAttributeType(2);
        this.m_Instances.deleteAttributeType(4);
    }

    @Override
    public Filter getFilter() {
        return new SortLabels();
    }

    public Filter getFilter(int sort, String range) {
        SortLabels result = new SortLabels();
        result.setSortType(new SelectedTag(0, SortLabels.TAGS_SORTTYPE));
        result.setAttributeIndices(range);
        return result;
    }

    protected Instances performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SortLabelsTest.fail("Exception thrown on setInputFormat(): \n" + ex.getMessage());
        }
        try {
            result = Filter.useFilter(icopy, this.m_Filter);
            SortLabelsTest.assertNotNull(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SortLabelsTest.fail("Exception thrown on useFilter(): \n" + ex.getMessage());
        }
        SortLabelsTest.assertEquals("Number of attributes", icopy.numAttributes(), result.numAttributes());
        SortLabelsTest.assertEquals("Number of instances", icopy.numInstances(), this.m_Instances.numInstances());
        int i = 0;
        while (i < result.numAttributes()) {
            SortLabelsTest.assertEquals("Number of values differ for attribute #" + (i + 1), icopy.attribute(i).numValues(), result.attribute(i).numValues());
            HashSet<String> valuesOriginal = new HashSet<String>();
            HashSet<String> valuesResult = new HashSet<String>();
            int n = 0;
            while (n < icopy.attribute(i).numValues()) {
                valuesOriginal.add(icopy.attribute(i).value(n));
                valuesResult.add(result.attribute(i).value(n));
                ++n;
            }
            SortLabelsTest.assertEquals("Values differ for attribute #" + (i + 1), valuesOriginal, valuesResult);
            ++i;
        }
        return result;
    }

    public void testCaseSensitive() {
        this.m_Filter = this.getFilter(0, "first-last");
        this.testBuffered();
        Instances result = this.performTest();
        String[] sorted = new String[]{"b", "g", "r"};
        int i = 0;
        while (i < sorted.length) {
            SortLabelsTest.assertEquals("Values differ for index #" + (i + 1), result.attribute(0).value(i), sorted[i]);
            ++i;
        }
    }

    public void testCaseInsensitive() {
        this.m_Filter = this.getFilter(1, "first-last");
        this.testBuffered();
        Instances result = this.performTest();
        String[] sorted = new String[]{"b", "g", "r"};
        int i = 0;
        while (i < sorted.length) {
            SortLabelsTest.assertEquals("Values differ for index #" + (i + 1), sorted[i], result.attribute(0).value(i));
            ++i;
        }
    }

    public void testUnchangedOrder() {
        this.m_Filter = this.getFilter(0, "first-last");
        this.testBuffered();
        Instances result = this.performTest();
        int i = 0;
        while (i < this.m_Instances.attribute(2).numValues()) {
            SortLabelsTest.assertEquals("Values differ for index #" + (i + 1), this.m_Instances.attribute(2).value(i), result.attribute(2).value(i));
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(SortLabelsTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(SortLabelsTest.suite());
    }
}

